package Ex19__9
  // Fluid Flow for the Practicing Chemical Engineer by James Patrick Abulencia and Louis Theodore,A John Wiley & Sons,Inc,publication
  // Edition : 1
  // Chapter : 19 Flow measurment
  // Illustrative Example 19.9 Page Number 259
  // Title - Diameter of the orfice plate
  //========================================================================

  model Ex19_9
    final constant Real pi = Modelica.Constants.pi "the value of pi";
    parameter Real m(unit = "lb/s") = 0.5 "Mass flow rate";
    parameter Real rho(unit = "lb/ft^3") = 0.075 "Density of air";
    parameter Real D1(unit = "in") = 4 "Diameter of the pipe";
    //========================================================================
    ///////Variable section/////////
    Real D2(unit = "in") "Diameter of the orifice";
    Real q(unit = "ft^3/s") "Volumeteric flow rate";
    Real D[8](each unit = "in") "Diameter of the orifice";
    //=========================================================================
    //////////Equation Section///////
  equation
    q = m / rho;
    D[1] = 0.5;//Assuming the value
//By trial and error method determining D2
    for i in 1:7 loop
      D[i + 1] = Ex19_9a(D[i]);
    end for;
    D2 = D[8];
  end Ex19_9;
  //==================================================================================

  //=============================================================================

  function Ex19_9a
    input Real D;//Input the value of D
    output Real Dnew;//Output the value of Dnew
  protected
    final constant Real pi = Modelica.Constants.pi;//the value of pi
    parameter Real g = 32.2;               //Acceleration due to gravity        unit : ft/s^2
    parameter Real Cv = 0.61;              //Coefficient of discharge
    parameter Real m_dot = 0.5;            //Mass flow rate                     unit : lb/s
    parameter Real rho = 0.075;            //Density of air                     unit : lb/ft^3
    parameter Real D1 = 4;                 //Diameter of the pipe               unit : in
    parameter Real rho_m = 62.42;          //Manometer fluid density            unit : lb/ft^3
    parameter Real h = 10;                 //Height difference in the manometer unit : in
    parameter Real q = m_dot / rho;        //Volumetric flow rate               unit : ft^3/s
  algorithm
//Equating the two equations
//v2=q/((pi*D2^2)/4) and v2=Cv((2*g*h*(rho_m-rho)/(rho*(1-(D2/D1)^4)))^0.5 to determine D2
    Dnew := ((4 * q * 12 ^ 3 / (pi * Cv)) * (1 / (2 * g * 12 * h * (rho_m - rho) / rho) ^ 0.5) * (1 - (D / D1) ^ 4) ^ 0.5) ^ 0.5;//Feet is converted to inch by a factor of 12
  end Ex19_9a;
end Ex19__9;
